import logging
import os
from sandbox import sdk2
from sandbox.projects.common.yabs.server.util.general import try_get_from_vault
from sandbox.projects.yabs.nanpu import BS_NANPU_BASE_DUMP, BS_NANPU_BIN_BASE_GEN
from sandbox.sdk2.helpers import subprocess as sp


class BsNanpuSingleBaseProcess(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        source_file = sdk2.parameters.Resource('BaseGen binary', resource_type=BS_NANPU_BIN_BASE_GEN, required=True)
        yt_token = sdk2.parameters.String('Yt token name', default='nanpu_tests_yt_token')
        basename = sdk2.parameters.String('Base name')

        with sdk2.parameters.Output:
            base_resource = sdk2.parameters.Resource('Base dump resource', resource_type=BS_NANPU_BASE_DUMP)

    def on_execute(self):
        logging.info('Creating new base dump for {}.'.format(self.Parameters.basename))

        yt_token = try_get_from_vault(self, self.Parameters.yt_token)
        binary_path = str(sdk2.ResourceData(self.Parameters.source_file).path)
        dir_path = str(os.path.join(str(self.path()), 'nanpu_bases'))
        os.mkdir(dir_path)

        args = [binary_path, 'gen_base', '--name', str(self.Parameters.basename), '--yt-token', yt_token, '--path', dir_path]
        with sdk2.helpers.ProcessLog(self, logger="binary") as pl:
            pl.logger.propagate = 1
            subprocess = sp.Popen(args, stdout=sp.PIPE, stderr=pl.stderr)
            subprocess.wait()
            base_path = subprocess.stdout.read().strip()
        logging.info('Generation succeded.')

        base_resource = BS_NANPU_BASE_DUMP(self, "Nanpu base dump", base_path, basename=self.Parameters.basename, ttl=21)
        resource_data = sdk2.ResourceData(base_resource)
        resource_data.ready()
        self.Parameters.base_resource = base_resource
