#!/usr/bin/env python
# encoding=utf-8

from sandbox import sdk2
from datetime import datetime, timedelta
from sandbox.sandboxsdk import environments
from email.header import Header
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.mime.base import MIMEBase
import re
import random
import logging
import copy
import json
import hashlib
import struct
import time
import requests
import smtplib
from sandbox.common.telegram import TelegramBot


class YabsServerMakeYtRequestSendResult(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yql_token_vault_name = sdk2.parameters.String("YQL Robot Token Vault Name", default="robot_google_yql_token", required=True)
        yt_cluster = sdk2.parameters.String("YT Cluster", default="hahn", required=True)

        message_row_template = sdk2.parameters.String("Message ROW template (.format(...))", default="", required=True, multiline=True)
        message_subject = sdk2.parameters.String("Subject", default="", required=True)

        yql_query = sdk2.parameters.String("YQL query", default="", required=True, multiline=True)
        yql_syntax_version = sdk2.parameters.Integer("YQL syntax version (0|1)", default=1, required=True)

        emails_list = sdk2.parameters.String("Emails list (comma separated)", default="", required=False)

        with sdk2.parameters.Group('Notification parameters') as notify_parameters:
            step_event = sdk2.parameters.Bool("Send STEP event", default=False)

            telegram_notification = sdk2.parameters.Bool("Send report to Telegram", default=False)
            with telegram_notification.value[True]:
                telegram_send_on_success = sdk2.parameters.Bool("Send report on SUCCESS", default=False)
                telegram_chat_id = sdk2.parameters.Integer("Telegram chat ID", required=True)
                telegram_bot_token_vault = sdk2.parameters.Vault("Vault secret contains Telegram bot token", required=True)


    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yql', version='1.2.91')
        )

    def yt_connect(self, yt_cluster):
        import yt.wrapper as yt

        logging.info("Try connect to " + str(yt_cluster))
        try:
            cfg = {
                "tabular_data_format": yt.JsonFormat(control_attributes_mode="row_fields"),
                "detached": False,
                "token": self.yql_token,
                "proxy": {"url": yt_cluster},

            }
            ytc = yt.YtClient(config=cfg)
            logging.info("Succesfully connected to {}".format(yt_cluster))

            return ytc
        except:
            logging.info("Can`t connect to {}".format(yt_cluster))
            return None

    def exec_yql_query(self, db, token, query):
        from yql.api.v1.client import YqlClient

        query = re.sub(r'\\', '', query)

        client = YqlClient(db=db, token=token)
        query = client.query(query, syntax_version=self.Parameters.yql_syntax_version)
        query.run()
        query.wait_progress()

        if not query.is_success:
            errors = []
            if query.errors:
                errors = [str(error) for error in query.errors]
            raise Exception("YQL request failed. Status: {}. Errors: {}".format(query.status, ' - '.join(errors)))

        result = []
        for table in query.get_results():
            table.fetch_full_data()

            columns = []
            for column_name, column_type in table.columns:
                columns.append(column_name)

            for row in table.rows:
                result.append(dict([(columns[i], value) for i, value in enumerate(row)]))

        return json.loads(json.dumps(result))

    def read_yt_table(self, yt_cluster, query):
        logging.info("Start reading yt table")

        yt_res = self.exec_yql_query(yt_cluster, self.yql_token, query)
        logging.info("OUT: {}\n".format(json.dumps(yt_res)))

        return yt_res

    def get_process_time(self, frmt='%Y-%m-%d', days=1):
        start_time = datetime.now() - timedelta(days=days)
        return start_time.strftime(frmt)

    def on_execute(self):
        logging.info("Started main process!")

        self.yql_token = sdk2.task.Vault.data(self.author, self.Parameters.yql_token_vault_name)

	yt_result = self.exec_yql_query(self.Parameters.yt_cluster, self.yql_token, self.Parameters.yql_query)

	processed_template_array = []
	for row in yt_result:
	    str_log = self.Parameters.message_row_template.format(row=row)
            logging.info("Processed row: " + str(str_log))

	    processed_template_array.append(str(str_log))

	processed_template = "\n".join(processed_template_array)

        current_date = self.get_process_time('%Y-%m-%d', 0)
        subject = self.Parameters.message_subject + " " + str(current_date)

	logging.info("Subject: " + subject)
	logging.info("Result: " + processed_template)

	if self.Parameters.emails_list != '':
	    self.send_email(subject, processed_template)

	if self.Parameters.telegram_chat_id:
            message = subject + '\n' + processed_template
            try:
                bot = TelegramBot(bot_token=self.Parameters.telegram_bot_token_vault.data())
                bot.send_message(self.Parameters.telegram_chat_id, message)
            except Exception as e:
                logging.warn("Telegram notification failed: {}".format(e.message))


    def send_email(self, subject, body_txt, format="text"):
        frm = 'Yandex Yt Requester <noreply@yandex.ru>'
        to = self.Parameters.emails_list.split(',')

        msg = MIMEMultipart('alternative')
        msg.set_charset('utf8')
        msg['From'] = frm
        msg['To'] = ', '.join(to)
        msg['Cc'] = ', '.join('mirage@yandex-team.ru')
        msg['Subject'] = Header(subject, 'UTF-8').encode()

        if format == "csv":
            body = MIMEText("", 'plain', 'utf8')
            msg.attach(body)

            attachment = MIMEBase('application', 'csv')

            filename = "data-%s.csv" % date_for_log
            header = 'Content-Disposition', 'attachment; filename="%s"' % filename
            attachment.add_header(*header)

            attachment.set_payload(body_txt)
            msg.attach(attachment)
        else:
            body = MIMEText(body_txt, 'plain', 'utf8')
            msg.attach(body)

        try:
            srv = smtplib.SMTP('yabacks.yandex.ru', port=25)
            srv.sendmail(frm, to, msg.as_string())
            srv.quit()
        except smtplib.SMTPException:
            raise Exception('No e-mails was sent. Internal SMTP exception occured')

    def send_telegram(self, message):
        try:
            bot = TelegramBot(bot_token=self.Parameters.telegram_bot_token_vault.data())
            bot.send_message(self.Parameters.telegram_chat_id, message)
        except Exception as e:
            logging.warn("Telegram notification failed: {}".format(e.message))

