import logging

from sandbox import sdk2
from sandbox.projects.yabs.panther.resource_types import PantherIndexBuilderBinary
from sandbox.projects.yabs.panther.common import PantherCommonIndexBuilder


class PantherBuildPantherIndex(PantherCommonIndexBuilder):

    class Parameters(PantherCommonIndexBuilder.Parameters):
        builder_binary = sdk2.parameters.LastResource('Panther builder binary', resource_type=PantherIndexBuilderBinary, required=True)

        with PantherCommonIndexBuilder.Parameters.builder_params() as builder_params:
            input_path = sdk2.parameters.String("Input YT path", required=True)
            output_path = sdk2.parameters.String("Output work dir path", default='/tmp', required=True)
            samples_count = sdk2.parameters.Integer("Offroad samples count", default=1000, required=True)

    def _get_command_parameters(self):
        return [
            '--input-yt-table', self.Parameters.input_path,
            '--output-yt-dir', self.Parameters.output_path,
            '--sample', str(self.Parameters.samples_count),
        ]

    def on_execute(self):
        logging.info('Build panther index')
        super(PantherBuildPantherIndex, self).on_execute()
