import logging

from sandbox import sdk2
from sandbox.projects.yabs.panther.resource_types import PantherTsarIndexBuilderBinary
from sandbox.projects.yabs.panther.common import PantherCommonIndexBuilder


class PantherBuildTsarIndex(PantherCommonIndexBuilder):

    class Requirements(sdk2.Task.Requirements):
        cores = 2
        ram = 8192

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(PantherCommonIndexBuilder.Parameters):
        builder_binary = sdk2.parameters.LastResource('Tsar builder binary', resource_type=PantherTsarIndexBuilderBinary, required=True)

        with PantherCommonIndexBuilder.Parameters.builder_params() as builder_params:
            input_path = sdk2.parameters.String("Input YT path", required=True)
            output_path = sdk2.parameters.String("Output work dir path", required=True)
            vector_size = sdk2.parameters.Integer("Vector size", default=50, required=True)
            use_parallel_reader = sdk2.parameters.Bool("Parallel reader", default=False, required=False)

    def _get_command_parameters(self):
        cmd = [
            '--input-yt-table', self.Parameters.input_path,
            '--output-yt-dir', self.Parameters.output_path,
            '--vector', str(self.Parameters.vector_size),
        ]
        if self.Parameters.use_parallel_reader:
            cmd.extend(['-p'])
        return cmd

    def on_execute(self):
        logging.info('Build panther index')
        super(PantherBuildTsarIndex, self).on_execute()
