import logging

import sandbox.sdk2.helpers
from sandbox import sdk2
from sandbox import common
from sandbox.sdk2.helpers import subprocess


class PantherCommonIndexBuilder(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        builder_binary = sdk2.parameters.Resource('Common builder binary', required=True)

        with sdk2.parameters.Group("YT params", collapse=False) as yt_params:
            yt_cluster = sdk2.parameters.String("YT cluster", default="hahn", required=True)
            yt_token_vault_name = sdk2.parameters.String("YT Token vault name", default="yt_token", required=True)

        with sdk2.parameters.Group("Builder params", collapse=False) as builder_params:
            force_mtime = sdk2.parameters.Integer("Force mtime", default=None, required=False)
            force_create = sdk2.parameters.Bool("Force create tables", default=True, required=False)

        with sdk2.parameters.Output():
            bases_info = sdk2.parameters.JSON('Bases info', default=None)

    def _get_command_parameters(self):
        raise NotImplementedError("Implement get_command_parameters()")

    def on_execute(self):
        import json

        logging.info('Started')
        self.bases_info_path = str(self.path('BASES_INFO.json'))
        bin_res = sdk2.ResourceData(self.Parameters.builder_binary)
        cmd = [
            str(bin_res.path),
            '--bases-info-file', self.bases_info_path,
        ]
        cmd.extend(self._get_command_parameters())
        if self.Parameters.force_mtime:
            cmd.extend(['--time', str(self.Parameters.force_mtime)])
        if self.Parameters.force_create:
            cmd.extend(['--force'])

        env = {
            'YT_PROXY': self.Parameters.yt_cluster,
            'YT_TOKEN': sdk2.task.Vault.data(self.author, self.Parameters.yt_token_vault_name)
        }

        builder_logger = logging.getLogger('build_index')
        logger_file = logging.FileHandler(str(self.log_path('builder.log')))
        builder_logger.addHandler(logger_file)
        with sandbox.sdk2.helpers.ProcessLog(self, builder_logger) as pl:
            co = subprocess.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)
            if co > 0:
                raise common.errors.TaskError('Builder finished with exit code: {}'.format(co))

        with open(self.bases_info_path, 'r') as bases_info:
            parsed_bases_info = json.loads(bases_info.read())
            for key in parsed_bases_info:
                logging.info('Base {}: {}'.format(key, parsed_bases_info[key]))
            self.Parameters.bases_info = parsed_bases_info
