import logging

import sandbox.sdk2.helpers
from sandbox import sdk2
from sandbox import common
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.yabs.panther.resource_types import PantherTsarMergerBinary


class PantherTsarImporter(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        merger_binary = sdk2.parameters.LastResource('Tsar merger binary', resource_type=PantherTsarMergerBinary, required=True)

        with sdk2.parameters.Group("YT params", collapse=False) as yt_params:
            yt_cluster = sdk2.parameters.String("YT cluster", default="hahn", required=True)
            yt_token_vault_name = sdk2.parameters.String("YT Token vault name", default="yt_token", required=True)

        with sdk2.parameters.Group("Import params", collapse=False) as importer_params:
            importer_input_banners_path = sdk2.parameters.String("Merger banner path", required=True)
            importer_caesar_dump_path = sdk2.parameters.String("Caesar dump path", default='//home/bs/logs/AdsCaesarBannersFullDump/latest', required=True)
            importer_output_table_path = sdk2.parameters.String("Merger banner path", required=True)
            importer_vector_id = sdk2.parameters.Integer("Vector id to load", default=44, required=True)
            importer_force_create_output = sdk2.parameters.Bool("Force create", default=True, required=True)

    def on_execute(self):
        logging.info('Started')
        bin_res = sdk2.ResourceData(self.Parameters.merger_binary)
        cmd = [
            str(bin_res.path),
            '--caesar-dump', self.Parameters.importer_caesar_dump_path,
            '--input-yt-table', self.Parameters.importer_input_banners_path,
            '--output-yt-table', self.Parameters.importer_output_table_path,
            '--vector', str(self.Parameters.importer_vector_id),
            '--recursive',
        ]
        if self.Parameters.importer_force_create_output:
            cmd.extend(['--force'])

        env = {
            'YT_PROXY': self.Parameters.yt_cluster,
            'YT_TOKEN': sdk2.task.Vault.data(self.author, self.Parameters.yt_token_vault_name)
        }

        importer_logger = logging.getLogger('importer')
        logger_file = logging.FileHandler(str(self.log_path('importer.log')))
        importer_logger.addHandler(logger_file)
        with sandbox.sdk2.helpers.ProcessLog(self, importer_logger) as pl:
            co = subprocess.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)
            if co > 0:
                raise common.errors.TaskError('Importer finished with exit code: {}'.format(co))
