import os
from sandbox.projects.common.arcadia import sdk as asdk


def get_arcadia_files(revision, file_paths):
    content = {}
    with asdk.mount_arc_path('arcadia-arc:/#{revision}'.format(revision=revision)) as mount_point:
        for path in file_paths:
            full_path = os.path.join(mount_point, path)
            with open(full_path, 'r') as f:
                content[path] = f.read()
    return content


def get_arcadia_file(revision, file_path):
    with asdk.mount_arc_path('arcadia-arc:/#{revision}'.format(revision=revision)) as mount_point:
        full_path = os.path.join(mount_point, file_path)
        with open(full_path, 'r') as f:
            return f.read()
