# This library is deprecated and replaced with fast_changes
# Still it is not deleted, because it can be useful if tables or queries become too big for CHYT in the future

import logging
import jinja2

logger = logging.getLogger(__name__)


def _update_condition(condition):
    if condition['field'] in ['Segment', 'TrafficType', 'Login', 'Domain']:
        condition['value'] = ','.join(['"{v}"'.format(v=v) for v in condition['value'].split(',')])
    if condition['field'] == 'PageID-ImpId':
        condition['field'] = '(PageID,ImpID)'
        condition['value'] = ','.join(['(' + v.replace('-', ',') + ')' for v in condition['value'].split(',')])


def _append_where(where, condition):
    where += '    {field} in ({value})'.format(
        field=condition['field'],
        value=condition['value']
    )
    return where


# TODO: Protect from SQL injections: https://a.yandex-team.ru/arc/trunk/arcadia/yql/library/python/yql/api/v1/examples/parameters.py
def generate_changes_yql_query(cluster, filters, changes_table_path, filter_template_txt, changes_template_txt, yql_tmp_folder):
    filter_template = jinja2.Template(filter_template_txt, undefined=jinja2.StrictUndefined)
    changes_template = jinja2.Template(changes_template_txt, undefined=jinja2.StrictUndefined)

    filter_query = ''
    filter_id = 0
    for filter in filters:
        filter_id += 1
        where_first = ''
        where_second = ''
        need_segment = False
        need_traffic_type = False
        need_partner_id = False
        need_login = False
        need_domain = False
        for condition in filter['conditions']:
            _update_condition(condition)
            if condition['field'] == 'Segment':
                need_segment = True
            if condition['field'] == 'TrafficType':
                need_traffic_type = True
            if condition['field'] == 'Segment':
                need_partner_id = True
            if condition['field'] == 'Segment':
                need_login = True
            if condition['field'] == 'Segment':
                need_domain = True
            if condition['field'] == 'DSPID':
                if where_first == '':
                    where_first = 'WHERE\n'
                else:
                    where_first += ' AND\n'
                where_first = _append_where(where_first, condition)
            else:
                where_second = _append_where(where_second, condition) + ' AND\n'
        filter_query += filter_template.render(
            WhereFirst=where_first,
            WhereSecond=where_second,
            NeedSegment=need_segment,
            NeedTrafficType=need_traffic_type,
            NeedPartnerID=need_partner_id,
            NeedLogin=need_login,
            NeedDomain=need_domain,
            CurrentPartnerShareFrom=filter['CurrentPartnerShareFrom'],
            CurrentPartnerShareTo=filter['CurrentPartnerShareTo'],
            NewPartnerShare=filter['NewPartnerShare'] if filter['NewPartnerShare'] else 'NULL',
            DeltaPartnerShare=filter['DeltaPartnerShare'] if filter['DeltaPartnerShare'] else 'NULL',
            ChangesFilterId=filter_id
        ) + '\n\n'

    return changes_template.render(
        Cluster=cluster,
        YqlTmpFolder=yql_tmp_folder,
        FilterQuery=filter_query,
        Filters=filters,
        ChangesTablePath=changes_table_path
    )
