from __future__ import unicode_literals
from __future__ import print_function

import re
import inspect
from six import iteritems


class FunctionNotFound(Exception):
    pass


def validate_config_functions(config):
    for operation_name, operation in iteritems(config['operations']):
        if 'function' in operation:
            function_name = operation['function']
        else:
            function_name = operation_name
        validate_function(function_name)


def validate_function(function_name):
    from sandbox.projects.yabs.partner_share.lib.operations import run_imported_operation
    from sandbox.projects.yabs.partner_share.tasks.apply_changes import TacmanApplyChanges

    if re.search(
        r"\b" + re.escape(function_name) + r"\b",
        inspect.getsource(run_imported_operation)
    ):
        return

    if any(name == function_name for name, _ in inspect.getmembers(TacmanApplyChanges)):
        return

    raise FunctionNotFound('Function {} not found in run_imported_operation or TacmanApplyChanges'.format(
        function_name
    ))
