import logging

logger = logging.getLogger(__name__)

CONTROL_YT_CLUSTER = 'hahn'
CONTROL_YT_PATH = '//home/yabs/tac-manager/control'


def _attr_name(attr, queue, task_type):
    return '{attr}_{queue}_{task_type}'.format(
        attr=attr,
        queue=queue,
        task_type=task_type,
    )


class ControlHelper():
    def __init__(self, yt_token):
        from yt.wrapper import YtClient

        self.yt = YtClient(proxy=CONTROL_YT_CLUSTER, token=yt_token)

    def get_control_attr(self, attr):
        return self.yt.get(CONTROL_YT_PATH + '/@' + attr)

    def set_control_attr(self, attr, value):
        path = CONTROL_YT_PATH + '/@' + attr
        logger.warn('Set %s = "%s"', path, value)
        self.yt.set(path, value)

    def get_issue_hint(self, queue, task_type):
        return self.get_control_attr(_attr_name('issue_hint', queue, task_type))

    def set_issue_hint(self, queue, task_type, value):
        self.set_control_attr(_attr_name('issue_hint', queue, task_type), value)

    def get_resource_id(self, queue, task_type):
        return self.get_control_attr(_attr_name('resource_id', queue, task_type))

    def set_resource_id(self, queue, task_type, value):
        self.set_control_attr(_attr_name('resource_id', queue, task_type), value)

    def get_command(self, queue, task_type):
        return self.get_control_attr(_attr_name('command', queue, task_type))

    def set_command(self, queue, task_type, value):
        self.set_control_attr(_attr_name('command', queue, task_type), value)
