import logging
from yt.wrapper import YtClient, ypath_join
from six import iteritems

logger = logging.getLogger(__name__)

SCHEMA_BASE = [
    {'type': 'uint64', 'name': 'DSPID', 'required': False},
    {'type': 'uint64', 'name': 'PageID', 'required': False},
    {'type': 'uint64', 'name': 'ImpID', 'required': False},
    {'type': 'uint64', 'name': 'PartnerShare', 'required': False},
]

SCHEMA_PARTIAL = [
    {'type': 'uint16', 'name': 'ChangesFilterId', 'required': False},
    {'type': 'uint64', 'name': 'PartnerID', 'required': False},
    {'type': 'uint64', 'name': 'NewPartnerShare', 'required': False},
    {'type': 'uint64', 'name': 'DeltaPartnerShare', 'required': False},
    {'type': 'uint64', 'name': 'PlannedPartnerShare', 'required': False},
]

SCHEMA_FILTER = SCHEMA_BASE + [
    {'type': 'uint8', 'name': 'IsSecondary', 'required': False},
] + SCHEMA_PARTIAL

SCHEMA_CHANGES = SCHEMA_FILTER + [
    {'type': 'uint8', 'name': 'IsOverwrittenByNextFilter', 'required': False},
]


def _create_table(yt, *args, **kwargs):
    logging.debug('Creating table {}'.format(args[1]))
    yt.create(*args, **kwargs)


def _create_single_tables(yt, i, result_dir):
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'tmp/pages_touched{}'.format(i)),
        recursive=True,
        force=True,
        attributes={'schema': SCHEMA_BASE},
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'tmp/page_dsp_filtered{}'.format(i)),
        recursive=True,
        force=True,
        attributes={'schema': SCHEMA_BASE},
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'tmp/pages_consistent{}'.format(i)),
        recursive=True,
        force=True,
        attributes={'schema': SCHEMA_BASE + [
            {'type': 'uint8', 'name': 'IsTurboOrTurboDesktop', 'required': False},
        ]},
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'tmp/changes{}'.format(i)),
        recursive=True,
        force=True,
        attributes={'schema': SCHEMA_FILTER},
    )


def create_filter_tables(yt_cluster, yt_token, filters, result_dir):
    yt = YtClient(proxy=yt_cluster, token=yt_token)

    for i in range(len(filters)):
        _create_single_tables(yt, i + 1, result_dir)
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'changes'),
        recursive=True,
        force=True,
        attributes={'schema': SCHEMA_CHANGES}
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'changes_imps'),
        recursive=True,
        force=True,
        attributes={
            'schema': SCHEMA_BASE + SCHEMA_PARTIAL + [
                {'type': 'uint8', 'name': 'IsClamped', 'required': False},
                {'type': 'double', 'name': 'rtb_revenue', 'required': False},
                {'type': 'double', 'name': 'rtb_tac', 'required': False},
                {'type': 'double', 'name': 'revenue', 'required': False},
                {'type': 'double', 'name': 'tac', 'required': False},
                {'type': 'double', 'name': 'PlannedPartnerPrice', 'required': False},
                {'type': 'string', 'name': 'Segment', 'required': False},
                {'type': 'string', 'name': 'TrafficType', 'required': False},
                {'type': 'string', 'name': 'Domain', 'required': False},
                {'type': 'string', 'name': 'Login', 'required': False},
                {'type': 'uint8', 'name': 'IsTurboOrTurboDesktop', 'required': False},
                {'type': 'uint8', 'name': 'IsOverwrittenByNextFilter', 'required': False},
            ]
        }
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'changes_stat'),
        recursive=True,
        force=True,
        attributes={
            'schema': [
                {'type': 'uint64', 'name': 'Rows', 'required': False},
                {'type': 'uint64', 'name': 'Pages', 'required': False},
                {'type': 'uint64', 'name': 'Imps', 'required': False},
                {'type': 'uint64', 'name': 'Clamps', 'required': False},
                {'type': 'uint64', 'name': 'Overwrites', 'required': False},
                {'type': 'double', 'name': 'Turnover', 'required': False},
                {'type': 'double', 'name': 'TurnoverRtb', 'required': False},
                {'type': 'double', 'name': 'PartnerPrice', 'required': False},
                {'type': 'double', 'name': 'PartnerPriceRtb', 'required': False},
                {'type': 'double', 'name': 'PlannedPartnerPrice', 'required': False},
                {'type': 'string', 'name': 'TurnoverSourceTable', 'required': False},
            ],
        }
    )
    _create_table(
        yt,
        'table',
        ypath_join(result_dir, 'changes_target'),
        recursive=True,
        force=True,
        attributes={
            'schema': [
                {'type': 'uint64', 'name': 'PlannedPartnerShare', 'required': False},
                {'type': 'uint64', 'name': 'Rows', 'required': False},
            ],
        }
    )


def create_output_tables(spec):
    output_schemas = {
        'hist_uneq': [
            {'type': 'int64', 'name': 'Date', 'required': False},
            {'type': 'int64', 'name': 'DSPID', 'required': False},
            {'type': 'int64', 'name': 'PartnerID', 'required': False},
            {'type': 'int64', 'name': 'PageID', 'required': False},
            {'type': 'int64', 'name': 'ImpID', 'required': False},
            {'type': 'string', 'name': 'Issue', 'required': False},
            {'type': 'string', 'name': 'Oneshot', 'required': False},
            {'type': 'string', 'name': 'Operation', 'required': False},
            {'type': 'int64', 'name': 'PartnerShare', 'required': False},
            {'type': 'string', 'name': 'PartnerShareUpdateTime', 'required': False},
            {'type': 'int64', 'name': 'PrevPartnerShare', 'required': False},
            {'type': 'string', 'name': 'User', 'required': False},
            {'type': 'uint64', 'name': 'PlannedPartnerShare', 'required': False},
        ],
        'pps_uneq': [
            {'type': 'int64', 'name': 'DSPID', 'required': False},
            {'type': 'int64', 'name': 'PartnerID', 'required': False},
            {'type': 'int64', 'name': 'PageID', 'required': False},
            {'type': 'int64', 'name': 'ImpID', 'required': False},
            {'type': 'int64', 'name': 'PartnerShare', 'required': False},
            {'type': 'int64', 'name': 'PartnerShareUpdateTime', 'required': False},
            {'type': 'uint64', 'name': 'PlannedPartnerShare', 'required': False},
        ],
        'page_dsp_uneq': [
            {'type': 'int64', 'name': 'DSPID', 'required': False},
            {'type': 'int64', 'name': 'PageID', 'required': False},
            {'type': 'int64', 'name': 'ImpID', 'required': False},
            {'type': 'int64', 'name': 'PartnerShare', 'required': False},
            {'type': 'uint64', 'name': 'PlannedPartnerShare', 'required': False},
        ],
        'changes_uneq': SCHEMA_CHANGES + [
            {'type': 'uint64', 'name': 'PrevPlannedPartnerShare', 'required': False},
        ],
    }

    yt = YtClient(proxy=spec['yt_cluster'], token=spec['yql_token'])

    for table, table_info in iteritems(spec['outputs']):
        if table not in output_schemas:
            continue

        _create_table(
            yt,
            'table',
            table_info['path'],
            recursive=True,
            force=True,
            attributes={'schema': output_schemas[table]}
        )
