import jinja2
from sandbox.common import fs
from sandbox.projects.yabs.partner_share.lib.yql_lib import run_yql_query
import logging

logger = logging.getLogger(__name__)

PARTNER_SHARE_KEYS = ['PageID', 'ImpID', 'PartnerID', 'DSPID']
EXTRACT_DIFROWS_TEMPLATE_PATH = 'sandbox/projects/yabs/partner_share/lib/diff/jinja/extract-difrows.jinja'


def _get_columns_func_expr(cols, func):
    subq = ""
    for col in cols:
        if subq:
            subq += ", "
        subq += func + '(`' + col + '`) AS `' + col + '`'
    return subq


def _get_columns_expr(cols):
    subq = ""
    for col in cols:
        if subq:
            subq += ", "
        subq += '`' + col + '`'
    return subq


def _extract_dif_rows(spec, table1, table2, left_only, right_only, keys):
    query_template_txt = fs.read_file(EXTRACT_DIFROWS_TEMPLATE_PATH).decode('utf-8')
    query_template = jinja2.Template(query_template_txt, undefined=jinja2.StrictUndefined)
    if table1.startswith('/'):
        table1 = '`' + table1 + '`'
    if table2.startswith('/'):
        table2 = '`' + table2 + '`'
    yql_query = query_template.render(
        Cluster=spec['yt_cluster'],
        YqlTmpFolder=spec['constants']['YQL_TMP_FOLDER'],
        tbl1=table1,
        tbl2=table2,
        tbl_dif1=left_only,
        tbl_dif2=right_only,
        cols=_get_columns_expr(keys),
        some_cols=_get_columns_func_expr(keys, 'SOME')
    )

    return run_yql_query(spec, yql_query)


def compare_changes_to_changes(spec):
    return _extract_dif_rows(
        spec=spec,
        table1=spec['inputs']['changes1'],
        table2=spec['inputs']['changes2'],
        left_only=spec['outputs']['changes_dif1']['path'],
        right_only=spec['outputs']['changes_dif2']['path'],
        keys=PARTNER_SHARE_KEYS
    )


def compare_changes_to_history(spec):
    return _extract_dif_rows(
        spec=spec,
        table1='(SELECT DSPID,PartnerID,PageID,ImpID FROM `{}` WHERE IsOverwrittenByNextFilter=0)'.format(
            spec['inputs']['changes']
        ),
        table2='(SELECT DSPID,PartnerID,PageID,ImpID FROM `{path}` WHERE Issue="{issue}" AND Operation IN ("inserted", "updated"))'.format(
            issue=spec['issue'],
            path=spec['inputs']['hist']
        ),
        left_only=spec['outputs']['hist_dif1']['path'],
        right_only=spec['outputs']['hist_dif2']['path'],
        keys=PARTNER_SHARE_KEYS
    )


def compare_history_to_changes(spec):
    return _extract_dif_rows(
        spec=spec,
        table1='(SELECT DSPID,PartnerID,PageID,ImpID FROM `{path}` WHERE Issue="{issue}" AND Operation IN ("inserted", "updated"))'.format(
            issue=spec['issue'],
            path=spec['inputs']['hist']
        ),
        table2='(SELECT DSPID,PartnerID,PageID,ImpID FROM `{}` WHERE IsOverwrittenByNextFilter=0)'.format(
            spec['inputs']['changes']
        ),
        left_only=spec['outputs']['audit_dif1']['path'],
        right_only=spec['outputs']['audit_dif2']['path'],
        keys=PARTNER_SHARE_KEYS
    )
