from sandbox.projects.yabs.partner_share.lib.request import retry_post_request, retry_get_request
import logging

logger = logging.getLogger(__name__)


def iframe_text(ticket, uid, author):
    return '<iframe src="https://ok.yandex-team.ru/tracker?_embedded=1&author={author}&object_id={ticket}&uid={uid}" frameborder=0 width=100% height=400px scrolling=yes>'.format(
        ticket=ticket,
        uid=uid,
        author=author,
    )


class OkHelper():
    def __init__(self, ok_token, approvals):
        self.ok_token = ok_token
        self.approvals = approvals

    def retry_post_request(self, command='', json_data=None):
        logger.debug('OK POST request: %s', json_data)
        result = retry_post_request(
            headers={
                'Authorization': 'OAuth {}'.format(self.ok_token),
                'Content-Type': 'application/json;charset=utf-8',
            },
            url='https://ok.yandex-team.ru/api/approvements/' + command,
            json=json_data,
        )
        logger.debug('OK POST result: %s', result.status_code)
        logger.debug('OK POST result: %s', result.reason)
        try:
            logger.debug('OK POST result: %s', result.json())
        except:
            logger.debug('OK POST result: %s', result.text)
        return result

    def retry_get_request(self, command=''):
        logger.debug('OK GET request: %s', command)
        result = retry_get_request(
            headers={
                'Authorization': 'OAuth {}'.format(self.ok_token)
            },
            url='https://ok.yandex-team.ru/api/approvements/' + command,
        )
        logger.debug('OK GET result: %s', result.status_code)
        logger.debug('OK GET result: %s', result.reason)
        try:
            logger.debug('OK POST result: %s', result.json())
        except:
            logger.debug('OK POST result: %s', result.text)
        return result

    def start_approve(self, ticket, uid, author, approve_type, text, admin_groups):
        return self.retry_post_request(json_data={
            'object_id': ticket,
            'uid': uid,
            'text': 'https://{domain}/request/{ticket}\n{text}'.format(
                domain='testing.tacman.yandex-team.ru' if ticket.startswith('TEST') else 'tacman.yandex-team.ru',
                ticket=ticket,
                text=text.encode('utf-8'),
            ),
            'type': 'tracker',
            'stages': self.approvals[approve_type]['stages'],
            'author': author,
            'groups': admin_groups,
            'is_parallel': True
        })

    def modify_approve(self, ticket, uid, author, action):
        uuid = self.retry_get_request(
            command='check/?object_id={ticket}&uid={uid}&author={author}'.format(
                ticket=ticket,
                uid=uid,
                author=author,
            )
        ).json().get('uuid')
        return self.retry_post_request(
            command='{uuid}/{action}/'.format(
                uuid=uuid,
                action=action,
            )
        )

    def suspend_approve(self, ticket, uid, author):
        self.modify_approve(ticket, uid, author, 'suspend')

    def resume_approve(self, ticket, uid, author):
        self.modify_approve(ticket, uid, author, 'resume')

    def close_approve(self, ticket, uid, author):
        self.modify_approve(ticket, uid, author, 'close')

    def get_approve(self, ticket, uid, author):
        try:
            uuid = self.retry_get_request(
                command='check/?object_id={ticket}&uid={uid}&author={author}'.format(
                    ticket=ticket,
                    uid=uid,
                    author=author,
                )
            ).json().get('uuid')
            return self.retry_get_request(
                command=uuid
            ).json()
        except:
            return {"status": "not_found"}

    def get_approve_status(self, ticket, uid, author):
        approve = self.get_approve(ticket, uid, author)
        return approve["status"]
