def _requests_retry_session(retries=3, backoff_factor=0.3, status_forcelist=(500, 502, 504)):
    import requests
    from requests.adapters import HTTPAdapter
    from requests.packages.urllib3.util.retry import Retry

    session = requests.Session()
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        status_forcelist=status_forcelist,
    )
    adapter = HTTPAdapter(max_retries=retry)
    session.mount('https://', adapter)
    return session


def retry_post_request(headers, url, json, timeout=10):
    return _requests_retry_session().post(url, headers=headers, json=json, timeout=timeout)


def retry_get_request(headers, url, timeout=10):
    return _requests_retry_session().get(url, headers=headers, timeout=timeout)
