from sandbox.common.rest import Client
from sandbox.common.proxy import OAuth
import logging

logger = logging.getLogger(__name__)


def get_sandbox_link(id):
    return "https://sandbox.yandex-team.ru/task/{}".format(id)


def make_semaphore_name(task_type, queue):
    if queue.startswith('TEST'):
        return task_type + '_TEST'
    else:
        return task_type


class SandboxHelper():
    def __init__(self, sandbox_token):
        self.sandbox_client = Client(
            base_url='https://sandbox.yandex-team.ru/api/v1.0',
            auth=OAuth(sandbox_token)
        )

    def get_task(self, task_id):
        return self.sandbox_client.task[task_id].read()

    def get_tasks(self, task_type, queue, limit=100):
        return self.sandbox_client.task.read(
            type=task_type,
            limit=limit,
            order='-id',
            input_parameters={'st_queue': queue},
            children=True,
            hidden=True,
            hints=[queue],
            fields=['id', 'time', 'status', 'requirements'],
        )

    def start_task(self, task_id):
        return self.sandbox_client.batch.tasks.start.update([task_id])

    def get_semaphore(self, task_type, queue):
        return self.sandbox_client.task.read(
            name=make_semaphore_name(task_type, queue),
            limit=1
        )
