
import os
import json
from argparse import ArgumentParser
from sandbox.common import fs
from sandbox.projects.yabs.partner_share.lib.st_helper import StartrekHelper


STARTREK_API_ENDPOINT = 'https://st-api.yandex-team.ru'


def get_config():
    return json.loads(fs.read_file('sandbox/projects/yabs/partner_share/lib/config/config.json'))


def main(**kwargs):
    parser = ArgumentParser()
    parser.add_argument("--ticket", dest="st_ticket", help="ST Ticket")
    parser.add_argument("--field", dest="st_filed", help="Field Name")
    parser.add_argument("--field-value", dest="st_filed_value", help="Field Value")
    parser.add_argument("--st-queue", dest="st_queue", help="ST Queue")
    parser.add_argument("--st-token", dest="st_token", help="ST Token")

    args = parser.parse_args()

    st_queue = None
    if args.st_queue:
        st_queue = args.st_queue
    else:
        print('Parameter --st-queue is mandatory')
        return

    config = get_config()
    print(st_queue)
    print(config['queues'][st_queue]['local_fields_prefix'])

    st_token = None
    if not args.st_token:
        st_token = os.environ.get('ST_TOKEN')
    else:
        st_token = args.st_token

    if not st_token:
        print('ST Token is not found')
        return

    st_helper = StartrekHelper(
        useragent='partner_share_tool',
        startrek_api_url=STARTREK_API_ENDPOINT,
        st_token=st_token,
        local_fields_prefix=config['queues'][st_queue]['local_fields_prefix']
    )

    print(args.st_ticket, args.st_filed, args.st_filed_value)
    st_helper.change_local_field(args.st_ticket, args.st_filed, args.st_filed_value)
