from sandbox import sdk2
from sandbox.projects.yabs.partner_share.lib.st_helper import (
    StartrekHelper,
    get_sandbox_link,
    get_queue_from_issue
)
from sandbox.projects.yabs.partner_share.lib.config.config import get_config

TESTING_STARTREK_API_ENDPOINT = 'https://st-api.test.yandex-team.ru'
STARTREK_API_ENDPOINT = 'https://st-api.yandex-team.ru'


class TacmanBaseStartrekPushStatus(sdk2.Task):
    class Parameters(sdk2.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "Yav secret with robot tokens",
            default="sec-01fnrae4z6bj38bfjdpxgrjggm",
            required=True
        )
        use_testing_startrek = sdk2.parameters.Bool('Use testing startrek')
        apply_new_tacman_status = sdk2.parameters.Bool(
            "Apply new status in TACMan ticket",
            default=False,
            required=True
        )
        issue = sdk2.parameters.String(label='Startrek issue of current task')
        with apply_new_tacman_status.value[True]:
            apply_new_tacman_status_on_failure = sdk2.parameters.Bool(
                "Apply new status in TACMan ticket on failure too",
                default=True,
                required=True
            )
            delay_on_success = sdk2.parameters.Integer(
                "After successful finish wait in minutes",
                default=0
            )
            status_after_delay = sdk2.parameters.String(
                "After waiting set new status"
            )

    def init_startrek(self):
        tokens = self.Parameters.tokens.data()
        st_queue = get_queue_from_issue(self.Parameters.issue)
        self.st_helper = StartrekHelper(
            useragent="sandbox",
            startrek_api_url=TESTING_STARTREK_API_ENDPOINT
                if self.Parameters.use_testing_startrek
                else STARTREK_API_ENDPOINT,
            st_token=tokens["st_token"],
            local_fields_prefix=self.config['queues'][st_queue]['local_fields_prefix']
        )

    def set_issue_status(self, status):
        self.set_info(
            "Setting {status} status for ticket <a href={url}>{ticket}</a>".format(
                status=status,
                url='https://st.yandex-team.ru/{}'.format(self.Parameters.issue),
                ticket=self.Parameters.issue
            ),
            do_escape=False
        )
        self.st_helper.change_local_field(self.Parameters.issue, "tacman_status", status)
        self.st_helper.add_comment(self.Parameters.issue, 'Status is now {status}, set by {sb_url}'.format(
            status=status,
            sb_url=get_sandbox_link(self.id)
        ))

    def delay_status(self):
        with self.memoize_stage.delay_status(commit_on_entrance=False):
            self.set_info('Waiting {} minutes before setting status to {}'.format(
                self.Parameters.delay_on_success,
                self.Parameters.status_after_delay
            ))
            self.st_helper.add_comment(self.Parameters.issue, 'Will set {status} in {min} minutes: {sb_url}'.format(
                status=self.Parameters.status_after_delay,
                min=self.Parameters.delay_on_success,
                sb_url=get_sandbox_link(self.id)
            ))

            import time
            time.sleep(self.Parameters.delay_on_success * 60)

        self.set_issue_status(self.Parameters.status_after_delay)

    def on_finish(self, prev_status, new_status):
        self.config = get_config()
        self.stage = self.config['stages'][self.Parameters.stage_name]

        if self.Parameters.apply_new_tacman_status:
            self.init_startrek()
            if self.Context.warnings:
                self.st_helper.add_comment(self.Parameters.issue, '{status} Warnings:\n\n- {warns}'.format(
                    status=self.stage['next_states']['process'],
                    warns='\n- '.join(self.Context.warnings)
                ))
            if new_status == "SUCCESS":
                self.set_issue_status(self.stage['next_states']['success'])
                if self.Parameters.delay_on_success and self.Parameters.status_after_delay:
                    self.delay_status()
            elif self.Parameters.apply_new_tacman_status_on_failure:
                self.set_issue_status(self.stage['next_states']['fail'])

    def on_break(self, prev_status, new_status):
        self.config = get_config()
        self.stage = self.config['stages'][self.Parameters.stage_name]

        if self.Parameters.apply_new_tacman_status and self.Parameters.apply_new_tacman_status_on_failure:
            self.init_startrek()
            self.set_issue_status(self.stage['next_states']['fail'])
