import logging
from sandbox import sdk2
from sandbox.projects.yabs.partner_share.tasks.base_startrek_push_status import (
    TacmanBaseStartrekPushStatus
)
from sandbox.sandboxsdk.environments import PipEnvironment

logger = logging.getLogger(__name__)


class TacmanDelayStatus(TacmanBaseStartrekPushStatus):

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 512
        environments = [
            PipEnvironment('yql', version='1.2.91', use_wheel=True),
            PipEnvironment('yandex-yt', version='0.9.17', use_wheel=True),
            PipEnvironment('startrek_client', version='2.5.0', use_wheel=True)
        ]

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    class Parameters(TacmanBaseStartrekPushStatus.Parameters):
        delay_minutes = sdk2.parameters.Integer('Delay in minutes before changing status', default=0)

    def on_execute(self):
        with self.memoize_stage.wait(commit_on_entrance=False):
            if self.Parameters.delay_minutes > 0:
                raise sdk2.WaitTime(self.Parameters.delay_minutes * 60)
