import abc
import six


class ModuleAdapterBase(six.with_metaclass(abc.ABCMeta, object)):
    """Base class for standalone and sandbox adapters."""

    def __init__(self, parameters, task_instance):
        self._parameters = parameters
        self._task_instance = task_instance

    def get_task_instance(self):
        return self._task_instance

    @abc.abstractmethod
    def create_module(self):
        pass

    @abc.abstractmethod
    def sync_resource(self, resource):
        pass

    @property
    def parameters(self):
        return self._parameters

    @property
    def task_instance(self):
        return self._task_instance

    @abc.abstractmethod
    def get_resource_attributes(self, resource_id):
        pass

    @abc.abstractmethod
    def get_resource_path(self, resource_id):
        pass
