from abc import abstractmethod

from sandbox import sdk2
from sandbox.projects.yabs.qa import adapter_base
from sandbox.projects.yabs.qa.mutable_parameters import MutableParameters


class SandboxAdapterBase(adapter_base.ModuleAdapterBase):
    def __init__(self, parameters, task_instance):
        super(SandboxAdapterBase, self).__init__(MutableParameters.__from_parameters__(parameters), task_instance)

    @staticmethod
    @abstractmethod
    def get_init_parameters_class():
        pass

    def sync_resource(self, resource):
        if isinstance(resource, int):
            resource = sdk2.Resource[resource]
        return str(sdk2.ResourceData(resource).path)

    def get_resource_attributes(self, resource_id):
        return sdk2.Resource[resource_id].__attrs__

    def get_resource_path(self, resource_id):
        return str(sdk2.Resource[resource_id].path)
