from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.interface import AmmoRequestlogModuleAdapterBase
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.qa.ammo_module.requestlog import EAmmoFileType, AmmoRequestlogModule
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox.parameters import (
    AmmoRequestlogGeneralParameters,
)
from sandbox.projects.yabs.qa.ammo_module.requestlog.utils.queryargs import update_queryargs
from sandbox.projects.common.dolbilka.resources import DPLANNER_EXECUTABLE
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common.yabs.server.util.libs.request_parser import HTTPRequest

from sandbox import sdk2


class AmmoRequestlogModuleGeneralSandboxAdapter(AmmoRequestlogModuleAdapterBase, SandboxAdapterBase):
    def __init__(self, parameters, task_instance, allow_repeated_queryargs=False):
        SandboxAdapterBase.__init__(self, parameters, task_instance)
        self._allow_repeated_queryargs = allow_repeated_queryargs
        self._http_parser = HTTPRequest()

    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestlogGeneralParameters

    def create_module(self):
        return AmmoRequestlogModule(self, update_ammo=self.parameters.update_ammo)

    def get_requestlog_path(self):
        return self.sync_resource(self.parameters.requestlog_resource)

    def get_requestlog_file_type(self):
        return EAmmoFileType[self.parameters.requestlog_file_type]

    def update_ammo_initialize(self):
        pass

    def update_request_method(self, request, hdr_tail):
        self._http_parser.from_string(request)
        update_queryargs(self._http_parser.queryargs, self.parameters.queryargs_update_dict)
        self._http_parser.cookies.update(self.parameters.cookies_update_dict)
        self._http_parser.headers.update(self.parameters.headers_update_dict)
        if self.parameters.transfer_test_id_to_queryargs:
            test_id_value = self._http_parser.headers.get(self.parameters.test_id_header.lower())
            if test_id_value:
                self._http_parser.queryargs[self.parameters.test_id_queryarg] = test_id_value
        return self._http_parser.to_string(
            wrapped=False,
            remove_connection_header=True,
            allow_repeated_queryargs=self._allow_repeated_queryargs,
            omit_handler_data=self.parameters.omit_handler_data,
        )

    def update_ammo_finalize(self):
        pass

    def get_dplanner_executable_path(self):
        return self.sync_resource(
            sdk2.Resource.find(DPLANNER_EXECUTABLE, attrs={'released': ReleaseStatus.STABLE})
            .order(-sdk2.Resource.id)
            .first()
        )
