from sandbox import sdk2
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_REQUEST_LOG_GZ
from sandbox.projects.yabs.qa.ammo_module.requestlog import EAmmoFileType


class AmmoRequestlogGeneralParameters(sdk2.Task.Parameters):
    requestlog_resource = sdk2.parameters.Resource('Requestlog resource', resource_type=YABS_SERVER_REQUEST_LOG_GZ, required=True)
    requestlog_file_type = sdk2.parameters.String('Type of requestlog file', choices=[(x.name, x.name) for x in list(EAmmoFileType)], default_value=EAmmoFileType.gzip.name)
    queryargs_update_dict = sdk2.parameters.JSON('Queryargs update dict', default_value={})
    cookies_update_dict = sdk2.parameters.JSON('Cookies update dict', default_value={})
    headers_update_dict = sdk2.parameters.JSON('Headers update dict', default_value={})
    transfer_test_id_to_queryargs = sdk2.parameters.Bool('Transfer test ID to queryargs from headers', default_value=True)
    update_ammo = sdk2.parameters.Bool('Update ammo', default_value=True)
    omit_handler_data = sdk2.parameters.Bool('Omit handler data', default_value=False)
    with transfer_test_id_to_queryargs.value[True]:
        test_id_header = sdk2.parameters.String('Test ID header name', default_value='Test-Id')
        test_id_queryarg = sdk2.parameters.String('Test ID queryarg name', default_value='test-id')
