from abc import ABCMeta, abstractmethod


class AmmoRequestlogModuleAdapterBase(object):

    __metaclass__ = ABCMeta

    @abstractmethod
    def get_requestlog_path(self):
        pass

    @abstractmethod
    def get_requestlog_file_type(self):
        pass

    @abstractmethod
    def update_ammo_initialize(self):
        pass

    @abstractmethod
    def update_request_method(self, request, hdr_tail):
        pass

    @abstractmethod
    def update_ammo_finalize(self):
        pass

    def set_content_type(self, content_type):
        pass

    @abstractmethod
    def get_dplanner_executable_path(self):
        pass

    class UpdateAmmoContext(object):
        def __init__(self, module):
            self._module = module

        def __enter__(self):
            self._module.update_ammo_initialize()
            return self

        def __exit__(self, *args):
            if args != [None, None, None]:
                return False
            self._module.update_ammo_finalize()

        def update_request(self, request, hdr_tail):
            return self._module.update_request_method(request, hdr_tail)

    def get_update_ammo_context(self):
        return self.UpdateAmmoContext(self)
