import base64
import json
import logging
import random

from urlparse import urlparse, urlunparse

from sandbox.projects.yabs.qa.ammo_module.requestlog import EAmmoFileType, AmmoRequestlogModule
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.interface import AmmoRequestlogModuleAdapterBase
from sandbox.projects.yabs.qa.utils.general import random_seed
from sandbox.projects.yabs.qa.constants import DEFAULT_YANDEXUID


logger = logging.getLogger(__name__)


def castable(obj, cast_type):
    try:
        cast_type(obj)
        return True
    except:
        return False


class AmmoRequestlogModuleYabsSpecificCommonAdapter(AmmoRequestlogModuleAdapterBase):

    def create_module(self, need_initial_load=True, content_type='primary_ammo'):
        return AmmoRequestlogModule(self, need_initial_load=need_initial_load, content_type=content_type)

    def get_requestlog_path(self):
        return self.sync_resource(self.parameters.requestlog_resource)

    def get_requestlog_file_type(self):
        return EAmmoFileType[self.parameters.requestlog_file_type]

    def set_content_type(self, content_type):
        self._content_type = content_type

    def update_request_method(self, request, hdr_tail):
        self._http_parser.from_string(request)

        if self._content_type == 'primary_ammo':
            handler_is_updatable = castable(self._http_parser.handler_data, int)
            request_is_filtered_out = any([
                handler_is_updatable and any([
                    self.parameters.filter_page_whitelist and self._http_parser.handler_data not in self.parameters.filter_page_whitelist,
                    self._http_parser.handler_data in self.parameters.filter_page_blacklist,
                ]),
                self.parameters.filter_request_whitelist and self._http_parser.headers['x-yabs-request-id'] not in self.parameters.filter_request_whitelist,
                self._http_parser.headers['x-yabs-request-id'] in self.parameters.filter_request_blacklist,
            ])
            if request_is_filtered_out:
                return None
            if self.parameters.skip_first_count and self._skipped_requests < self.parameters.skip_first_count:
                self._skipped_requests += 1
                return None
            if self.parameters.replace_page_list and castable(self._http_parser.handler_data, int):
                self._http_parser.handler_data = str(random.choice(self.parameters.replace_page_list))
            self._http_parser.queryargs.update(self.parameters.queryargs_update_dict)
            self._http_parser.queryargs['test-id'] = self._http_parser.headers['x-yabs-request-id']
            self._http_parser.cookies.update(self.parameters.cookies_update_dict)
            self._http_parser.cookies.update({'yabs-exp-sid': self._debug_cookie})
            if self.parameters.set_default_yandexuid and 'yandexuid' not in self._http_parser.cookies:
                self._http_parser.cookies.update({'yandexuid': DEFAULT_YANDEXUID})
            self._http_parser.headers.update(self.parameters.headers_update_dict)
            self._http_parser.headers.update({
                'x-yabs-debug-token': self._debug_cookie,
                'x-yabs-debug-output': self.parameters.debug_output_mode,
                'x-yabs-deterministic-request-id': '1'
            })
            with random_seed(self._http_parser.headers['x-yabs-request-id']):
                self._http_parser.headers['x-yabs-test-random'] = str(random.randint(*self.parameters.random_range_list))

            if self.parameters.ab_experiment_settings:
                additional_expflags_header = 'x-yabs-additional-expflags'

                testid = None
                for data in self.parameters.ab_experiment_settings:
                    if 'HANDLER' in data and data['HANDLER'] == 'BIGB_MAIN':
                        if 'TESTID' in data and len(data['TESTID']) == 1:
                            testid = data['TESTID'][0]

                if testid:
                    # https://a.yandex-team.ru/arcadia/yabs/server/config/templates/yabs-metapartner?rev=r9620268#L221
                    header_length_limit = 32 * 2 ** 10
                    additional_expflags = base64.b64encode(json.dumps(self.parameters.ab_experiment_settings))
                    if len(additional_expflags) > header_length_limit:
                        raise ValueError('{} header value is too large: {} > {}'.format(additional_expflags_header, len(additional_expflags), header_length_limit))
                    self._http_parser.headers.update({
                        additional_expflags_header: additional_expflags
                    })

            referer_header_key = 'referer'

            if self.parameters.cut_referer_path and referer_header_key in self._http_parser.headers and 'x-yabs-nanpu-req-id' not in self._http_parser.headers:
                referer = self._http_parser.headers[referer_header_key]
                parsed = urlparse(referer)
                referer = urlunparse((parsed.scheme, parsed.netloc, '', '', '', ''))
                self._http_parser.headers[referer_header_key] = referer

        elif self._content_type == 'secondary_count_links':
            if self._http_parser.handler == 'an':
                # https://st.yandex-team.ru/BSSERVER-17609
                # https://st.yandex-team.ru/SHMDUTY-350#625d6e9e68a01b72903a4587
                # Some links are formatted as /an/count/XXXXXX which leads to handler being parsed as 'an' and handler_data being parsed as 'count/XXXXXX'
                # In production environment 'an' prefix is being cut off by balancer
                self._http_parser.handler = ''

        return self._http_parser.to_string(wrapped=False, remove_connection_header=True)

    def update_ammo_finalize(self):
        pass
