import logging
import random

from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common.dolbilka.resources import DPLANNER_EXECUTABLE
from sandbox.projects.common.yabs.server.util.libs.request_parser import HTTPRequest
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.yabs_specific.common import AmmoRequestlogModuleYabsSpecificCommonAdapter
from sandbox.projects.yabs.qa.utils.general import random_seed
from sandbox.projects.yabs.qa.constants import DEBUG_COOKIE
from sandbox.projects.yabs.qa.ammo_module.requestlog.utils.queryargs import update_queryargs

from .parameters import AmmoRequestlogYabsSpecificParameters, AmmoRequestlogYabsSpecificBaseParameters


def castable(obj, cast_type):
    try:
        cast_type(obj)
        return True
    except:
        return False


class AmmoRequestlogModuleYabsSpecificSandboxAdapter(AmmoRequestlogModuleYabsSpecificCommonAdapter, SandboxAdapterBase):
    def __init__(self, parameters, task_instance, debug_cookie=DEBUG_COOKIE, content_type='primary_ammo'):
        SandboxAdapterBase.__init__(self, parameters, task_instance)
        self._http_parser = HTTPRequest()
        self._debug_cookie = debug_cookie
        self._content_type = content_type

    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestlogYabsSpecificParameters

    def update_ammo_initialize(self):
        self._skipped_requests = 0
        if self.parameters.skip_first_count:
            logging.info('Skipping first {} requests'.format(self.parameters.skip_first_count))

    def get_dplanner_executable_path(self):
        return self.sync_resource(sdk2.Resource.find(DPLANNER_EXECUTABLE, attrs={'released': ReleaseStatus.STABLE}).order(-sdk2.Resource.id).first())


class AmmoRequestlogModuleYabsStatPerformanceSandboxAdapter(AmmoRequestlogModuleYabsSpecificSandboxAdapter):

    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestlogYabsSpecificBaseParameters

    def update_request_method(self, request, hdr_tail):
        self._http_parser.from_string(request)
        self._http_parser.headers['x-yabs-deterministic-request-id'] = '1'
        with random_seed(self._http_parser.headers['x-yabs-request-id']):
            self._http_parser.headers['x-yabs-test-random'] = str(random.randint(*self.parameters.random_range_list))

        update_queryargs(self._http_parser.queryargs, self.parameters.queryargs_update_dict)
        return self._http_parser.to_string(wrapped=False, remove_connection_header=True)
