import json
from enum import Enum

from sandbox import sdk2
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_REQUEST_LOG_GZ
from sandbox.projects.yabs.qa.ammo_module.requestlog import EAmmoFileType
from sandbox.projects.yabs.qa.ammo_module.requestlog.constants.queryargs import ShmSysConstUpdate


EDebugOutput = Enum(
    value='EDebugOutput',
    names=[
        ('json', 1),
        ('proto-binary', 2),
        ('proto_binary', 2),
        ('proto-text', 3),
        ('proto_text', 3),
        ('proto-json', 4),
        ('proto_json', 4)
    ]
)


class StringifiedList(sdk2.parameters.JSON):
    default_value = []

    @classmethod
    def cast(cls, value):
        value = sdk2.parameters.JSON.cast(value)
        if not isinstance(value, list):
            raise ValueError("This parameter supports only list")
        if any([isinstance(item, (list, dict)) for item in value]):
            raise ValueError("This parameter does not support nested lists or objects")
        return map(str, value)


class AmmoRequestlogYabsSpecificBaseParameters(sdk2.Task.Parameters):
    requestlog_resource = sdk2.parameters.Resource('Requestlog resource', resource_type=YABS_SERVER_REQUEST_LOG_GZ)
    requestlog_file_type = sdk2.parameters.String('Type of requestlog file', choices=[(x.name, x.name) for x in list(EAmmoFileType)], default_value=EAmmoFileType.gzip.name)
    debug_output_mode = sdk2.parameters.String('Debug output mode', choices=[(x.name, x.name) for x in EDebugOutput], default_value=EDebugOutput.proto_binary.name)
    use_default_debug_cookie = sdk2.parameters.Bool('Use default debug cookie', default=True)
    with sdk2.parameters.Group('Update requests') as update_requests_parameters:
        random_range_list = sdk2.parameters.JSON('Random range bounds', default_value=[500000001, 4294967295])
        skip_first_count = sdk2.parameters.Integer('Skip first N requests', default_value=0)
        queryargs_update_dict = sdk2.parameters.JSON(
            'Queryargs update dict',
            default_value={},
        )


class AmmoRequestlogYabsSpecificParameters(AmmoRequestlogYabsSpecificBaseParameters):
    with sdk2.parameters.Group('Update requests') as update_requests_parameters:
        queryargs_update_dict = sdk2.parameters.JSON(
            'Queryargs update dict',
            default_value={
                "sysconst-update": ShmSysConstUpdate.FT_SYS_CONST_UPDATE,
                "abd": "0",
            }
        )
        cookies_update_dict = sdk2.parameters.JSON('Cookies update dict', default_value={})
        headers_update_dict = sdk2.parameters.JSON(
            'Headers update dict',
            default_value={
                "x-yabs-debug-options-json": json.dumps({
                    "business": False,
                    "trafaret": False,
                    "logs": True,
                    "trace": False,
                    "keywords": False,
                    "mx_zero_features": False,
                    "ext_http_entities": True,
                    "mx": False,
                    "exts": True,
                    "debug_log": False,
                })
            }
        )
        filter_page_whitelist = StringifiedList('Filter page whitelist', default_value=[])
        filter_page_blacklist = StringifiedList('Filter page blacklist', default_value=[])
        filter_request_whitelist = StringifiedList('Filter request_id whitelist', default_value=[])
        filter_request_blacklist = StringifiedList('Filter request_id blacklist', default_value=[])
        replace_page_list = sdk2.parameters.JSON('Replace page list', default_value=[])
        set_default_yandexuid = sdk2.parameters.Bool('Set default yandexuid', default_value=False)

    cut_referer_path = sdk2.parameters.Bool('Cut referer path (see BSSERVER-13651 for details)', default_value=False)
    ab_experiment_settings = sdk2.parameters.JSON('AB experiment settings', default_value={})
