import json
import os

from sandbox.common.rest import Client
from sandbox.projects.common.yabs.server.util.libs.request_parser import HTTPRequest
from sandbox.projects.yabs.qa.constants import DEBUG_COOKIE
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.yabs_specific.common import AmmoRequestlogModuleYabsSpecificCommonAdapter


def castable(obj, cast_type):
    try:
        cast_type(obj)
        return True
    except:
        return False


class AmmoRequestlogModuleYabsSpecificStandaloneAdapter(AmmoRequestlogModuleYabsSpecificCommonAdapter, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', debug_cookie=DEBUG_COOKIE, work_dir=os.curdir, content_type='primary_ammo'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir=logs_dir, resource_cache_dir=resource_cache_dir)
        self._http_parser = HTTPRequest()
        self._client = Client()
        self._debug_cookie = debug_cookie
        self._content_type = content_type

    def update_ammo_initialize(self):
        self._skipped_requests = 0

    def get_dplanner_executable_path(self):
        resource_data = self._client.resource.read(
            limit=100,
            order='-id',
            type='DPLANNER_EXECUTABLE',
            attrs=json.dumps({'released': 'stable'})
        )['items'][0]
        return self.sync_resource(resource_data['id'])
