from collections import OrderedDict

BASE_SYS_CONST_UPDATE = (
    ("FilterLogProbability", 20000),
    ("match-log-mode", 0),
    ("EnableBigbWithTvm", 0),
    ("request-log-probability", 1000000),
    ("MaxStageTimingsLogProbability", 10000),
    ("StageTimingsLogProbability", 10000),
    ("DisableDspCreativeDataBasesFallback", 0),
    ("FastFiltrationCacheAddingFiltrationTTL", 0),
    ("CalcL3TsarsOnMeta", 0),
    ("DisableSaasResourcesFallback", 0),
)

FT_SYS_CONST_UPDATE = BASE_SYS_CONST_UPDATE + (
    ("ss-skip-token-enabled", 0),
    ("UseGoalnetService", 1),
)
PERF_META_SYS_CONST_UPDATE = BASE_SYS_CONST_UPDATE + (
    ("ss-skip-token-enabled", 1),
)
KVRS_SAAS_SYS_CONST_UPDATE = FT_SYS_CONST_UPDATE + (
    ("FetchBannerTsarsFromSaaS", 1),
)


def sys_const_update_to_string(sys_const_update):
    return ','.join(map(
        lambda x: '{}:{}'.format(*x),
        sys_const_update
    ))


class TestEnvSysConstUpdate(object):
    FT_SYS_CONST_UPDATE = OrderedDict(FT_SYS_CONST_UPDATE)
    PERF_META_SYS_CONST_UPDATE = OrderedDict(PERF_META_SYS_CONST_UPDATE)
    KVRS_SAAS_SYS_CONST_UPDATE = OrderedDict(KVRS_SAAS_SYS_CONST_UPDATE)


class ShmSysConstUpdate(object):
    FT_SYS_CONST_UPDATE = sys_const_update_to_string(FT_SYS_CONST_UPDATE)
