import argparse
import logging

from library.python import oauth as lpo
from yt.wrapper import YtClient
from yql.api.v1.client import YqlClient
from sandbox.projects.yabs.qa.bases.sample_tables.run import run_sample_tables
from sandbox.projects.yabs.qa.bases.sample_tables.tables import TABLES_TO_SAMPLE
from sandbox.projects.yabs.qa.template_utils import load_template


logging.basicConfig(level=logging.DEBUG)
logging.getLogger('yql.client.request').setLevel(logging.INFO)
logging.getLogger('urllib3.connectionpool').setLevel(logging.WARNING)
logging.getLogger('yt.packages.urllib3.connectionpool').setLevel(logging.WARNING)

CLIENT_ID = "df5311c4f3bc49cda812977810b67adc"  # https://oauth.yandex-team.ru/client/df5311c4f3bc49cda812977810b67adc
CLIENT_SECRET = "3a72f6f3701a41a0b9536973d73f15d4"


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--proxy', default='hahn', help='YT cluster')
    parser.add_argument('-i', '--input-prefix', required=True, help='Input prefix')
    parser.add_argument('-o', '--output-prefix', help='Output prefix, will use input prefix if not specified')
    parser.add_argument('--dry-run', action='store_true', help='Do not launch operations')
    args = parser.parse_args()

    oauth_token = lpo.get_token(CLIENT_ID, CLIENT_SECRET, raise_errors=True)
    yt_client = YtClient(proxy=args.proxy, token=oauth_token)
    yt_client_lock = YtClient(proxy=args.proxy, token=oauth_token)
    yql_client = YqlClient(token=oauth_token)

    query_template = load_template(
        'sample_tables.sql',
        templates_dir='sandbox/projects/yabs/qa/bases/sample_tables/templates'
    )

    run_sample_tables(
        args.input_prefix,
        query_template,
        TABLES_TO_SAMPLE,
        yt_client=yt_client,
        yt_client_lock=yt_client_lock,
        yt_client_eventlog=yt_client,
        yt_pool='',
        yql_client=yql_client,
        output_node=args.output_prefix or args.input_prefix,
        yt_cluster=args.proxy,
        dry_run=args.dry_run
    )
