from enum import Enum
from hashlib import md5
from sandbox import sdk2


class SamplingStrategy(Enum):
    full = 'full'
    sampled = 'sampled'


class SamplingStrategyParameter(sdk2.parameters.String):
    description = 'Data sampling strategy'
    name = 'sampling_strategy'
    default = SamplingStrategy.full.value
    default_value = SamplingStrategy.full.value
    choices = [(strategy.name, strategy.value) for strategy in SamplingStrategy]


class SamplingYtPool(sdk2.parameters.String):
    description = 'Yt pool for yql sampling operation'
    name = 'sampling_yt_pool'
    default_value = 'yabs-cs-sandbox-sampling'


class SamplingQueryTemplateResourceParameter(sdk2.parameters.Resource):
    description = 'Resource with sampling query template'
    name = 'sampling_query_template'


class SamplingTablesResourceParameter(sdk2.parameters.Resource):
    """ Should contain tables in the same format as config sandbox.projects.yabs.qa.bases.sample_tables.tables.TABLES_TO_SAMPLE
    """
    description = 'Resource with sampling tables config'
    name = 'sampling_tables'


class FindTablesForSampling(sdk2.parameters.Bool):
    name = 'find_tables_for_sampling'
    description = 'Find big tables for sampling'
    default_value = False


class SamplingTablesBlackListResourceParameter(sdk2.parameters.Resource):
    description = 'Resource with black list of tables for sampling'
    name = 'sampling_tables_black_list'


class MinRowsCountForSamplingTables(sdk2.parameters.Integer):
    """Tables with rows count more then this value will be sampled
    """
    description = 'Min rows count for sampling tables'
    name = 'min_rows_count_for_sampling_tables'
    default_value = 15000000  # 15_000_000


class KeysForSamplingTables(sdk2.parameters.List):
    name = 'sampling_tables_keys'
    description = 'Keys for sampling tables'
    default_value = ['BannerID', 'CreativeID', 'GroupExportID', 'OrderID']


def get_sampling_parameters_hash(query_template_resource_id, sampling_tables_resource_id, min_rows_count, sampling_keys, black_list_tables_resource_id, find_tables_for_sampling):
    sampling_hash_obj = md5()
    sampling_hash_obj.update(str(query_template_resource_id).encode('utf-8'))
    sampling_hash_obj.update(str(sampling_tables_resource_id).encode('utf-8'))
    sampling_hash_obj.update(str(min_rows_count).encode('utf-8'))
    for key in sampling_keys:
        sampling_hash_obj.update(key.encode('utf-8'))
    sampling_hash_obj.update(str(black_list_tables_resource_id).encode('utf-8'))
    if find_tables_for_sampling:
        sampling_hash_obj.update(str(find_tables_for_sampling).encode('utf-8'))
    return sampling_hash_obj.hexdigest()
