PRAGMA yt.Pool = '{{ yt_pool }}';

USE {{ cluster_name }};

$event_log =
SELECT * FROM CONCAT(`{{event_logs|join('`,\n`')}}`);

$sampled_event_log = SELECT
    CAST(bannerid AS Uint64) AS BannerID,
    CAST(groupexportid AS Uint64) AS GroupExportID,
    CAST(creativeid AS Uint64) AS CreativeID,
    CAST(orderid AS Uint64) AS OrderID,
    CAST(grouporderid AS Uint64) AS GroupOrderID,
    597 AS LinearModelID,
FROM $event_log
WHERE (CAST(eventhash AS Uint64) + CAST(eventid AS Uint64)) % 10007 < 500

UNION ALL

SELECT
    0 AS BannerID,
    0 AS GroupExportID,
    0 AS CreativeID,
    0 AS OrderID,
    0 AS GroupOrderID,
    597 AS LinearModelID,
;

$OrderID_and_GroupOrderID =
SELECT OrderID FROM $sampled_event_log
UNION ALL
SELECT GroupOrderID AS OrderID,
FROM $sampled_event_log
;

{% for sampling_table_config in sampling_table_configs %}
INSERT INTO `{{ sampling_table_config.intermediate_absolute_output_path }}`
WITH TRUNCATE
SELECT * FROM `{{ sampling_table_config.absolute_input_path }}` VIEW raw AS original_table
LEFT SEMI JOIN
{%- if sampling_table_config.event_join_key[0] == 'OrderID' %}
    $OrderID_and_GroupOrderID
{%- else %}
    $sampled_event_log
{%- endif %}
AS sampled_event_log
ON (
{%- for key in sampling_table_config.event_join_key %}
    {%- if not loop.first -%}
        AND
    {%- endif %}
    sampled_event_log.{{key}}=CAST(original_table.{{key}} AS Uint64)
{%- endfor %}
)
{%- if sampling_table_config.sort_key %}
ORDER BY {{ sampling_table_config.sort_key | join(", ") }}
{%- endif -%}
;
{% endfor %}
