import logging

import requests


logger = logging.getLogger(__name__)


class Format(object):
    JSON = 'JSON'
    JSONCompact = 'JSONCompact'


class ClickhouseHttpClient(object):
    """
    Based on https://clickhouse.tech/docs/v19.14/en/interfaces/http/
    """

    def __init__(self, host, port=8123):
        self.host = host
        self.port = port

    def execute_query(self, query, **query_params):
        params = {'query': query}
        params.update({
            'param_{}'.format(param_name): param_value
            for param_name, param_value in query_params.items()
        })
        url = '{scheme}://{host}:{port}'.format(scheme='https', host=self.host, port=self.port)
        r = requests.get(url, params=params)
        return r

    def execute_with_format(self, query, output_format=Format.JSON, **query_params):
        query += '\nFORMAT {output_format}'.format(output_format=output_format)

        r = self.execute_query(query, **query_params)
        if r.status_code not in (requests.codes.ok, ):
            logger.debug(r.content)

        r.raise_for_status()
        if output_format in (Format.JSON, Format.JSONCompact):
            result = r.json()
            return result["meta"], result["data"]
        return r.content
