import json

DEBUG_COOKIE = '8dfdd2c712345678'
DEFAULT_YANDEXUID = '8133709081515186301'
YABS_OWN_POOL_OWNER = 'YABS_SERVER_SANDBOX_TESTS_OWN_POOL'

NULL_STUB_SERVICES_SET = {
    'adv_machine',
    'bigb_tvm_client',
    'bigb_user_storage',
    'caas',
    'daemon_tvm_client',
    'goods_hint',
    'gozora',
    'metrika_vacuum_goal',
    'metrika_vacuum_view',
    'pcode_renderer',
    'pcode_renderer_dev',
    'rmp_hint',
    'rtb_cache',
    'rtb_cache_post',
    'stat_dict',
    'yacofast_ssp',
    'rank_cache_set',
}
IGNORED_CACHEDEMON_STUBS = {
    # Handled separately via empty bscount stub
    'bscount_fbs',
    'bscount_fbs2',
    # engine handlers
    'get_data',
    'metacount',
    'tracker_notify_impression',
    'write_wide',
    'stat_dict',
}

DEFAULT_UPDATE_QUERYARGS_JSON = json.dumps({
    'sysconst-update': 'request-log-probability:1000000,match-log-mode:0'
})

DEFAULT_UPDATE_COOKIES_JSON = json.dumps({
    'yabs-exp-sid': DEBUG_COOKIE
})

DEFAULT_UPDATE_HEADERS_JSON = json.dumps({
    'x-yabs-debug-token': DEBUG_COOKIE,
    'x-yabs-deterministic-request-id': '1',
    'x-yabs-test-time': '1483261200',
    'x-yabs-debug-options-json': json.dumps({
        "business": False,
        "trafaret": False,
        "logs": True,
        "trace": False,
        "filter_log": False,
        "keywords": False,
        "match_log": False,
        "mx_zero_features": False,
        "mx": False,
        "exts": True,
        "ext_http_entities": True,
    }),
    'x-yabs-debug-output': 'json',
    'x-yabs-test-random': '50000000001'
})

# DEFAULT_TEST_RANDOM_RANGE_STR = '{}-{}'.format(5 * 10**8 + 1, (1<<32) - 1)  # not right away
DEFAULT_TEST_RANDOM_RANGE_STR = ''

NULL_STUB_SERVICES = list(NULL_STUB_SERVICES_SET)

META_ROLES = META_MODES = ['bs', 'bsrank', 'yabs']
ENGINE_ROLES = ['meta', 'stat']

AB_EXPERIMENT_OBSERVATIONS = {
    '1063425': 'Stable vs Prestable all',
    '1309117': 'Stable vs Prestable YABS',
    '1309116': 'Stable vs Prestable BS',
}

B_IN_KB = 1 << 10
KB_IN_MB = 1 << 10
MB_IN_GB = 1 << 10
B_IN_MB = B_IN_KB * KB_IN_MB


class SamplingStrategies(object):
    FULL = 'full'
    SAMPLED = 'sampled'
