from sandbox.projects.yabs.qa.dolbilo_module.simple import DolbiloModule
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.interface import DolbiloModuleAdapterInterface
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox.parameters import DolbiloModuleParameters
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.common.dolbilka.resources import DEXECUTOR_EXECUTABLE
from sandbox.common.types.task import ReleaseStatus
from sandbox import sdk2


class DolbiloModuleSandboxAdapter(DolbiloModuleAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return DolbiloModuleParameters

    def get_d_executor_path(self):
        return self.sync_resource(sdk2.Resource.find(DEXECUTOR_EXECUTABLE, attrs={'released': ReleaseStatus.STABLE}).order(-sdk2.Resource.id).first())

    def get_shoot_request_limit(self):
        return self.parameters.shoot_request_limit

    def get_shoot_threads(self):
        return self.parameters.shoot_threads

    def get_request_timeout(self):
        return self.parameters.request_timeout

    def get_store_plan_in_memory(self):
        return self.parameters.store_plan_in_memory

    def get_circular_session(self):
        return self.parameters.circular_session

    def get_shoot_mode(self):
        return self.parameters.mode

    def get_shoot_mode_args(self):
        return self.parameters.mode_arg

    def create_module(self):
        return DolbiloModule(self)
