import json

from sandbox.projects.yabs.qa.dolbilo_module.simple import DolbiloModule
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.interface import DolbiloModuleAdapterInterface
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.common.rest import Client


class DolbiloModuleStandaloneAdapter(DolbiloModuleAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)

    def get_d_executor_path(self):
        resource_data = Client().resource.read(limit=100,
                                               order='-id',
                                               type='DEXECUTOR_EXECUTABLE',
                                               attrs=json.dumps({'released': 'stable'}))['items'][0]
        return self.sync_resource(resource_data['id'])

    def get_shoot_request_limit(self):
        return self.parameters.shoot_request_limit

    def get_shoot_threads(self):
        return self.parameters.shoot_threads

    def get_request_timeout(self):
        return self.parameters.request_timeout

    def get_store_plan_in_memory(self):
        return self.parameters.store_plan_in_memory

    def get_circular_session(self):
        return self.parameters.circular_session

    def get_shoot_mode(self):
        return self.parameters.mode

    def get_shoot_mode_args(self):
        return self.parameters.mode_arg

    def create_module(self):
        return DolbiloModule(self)
