import inspect
from sandbox.projects.yabs.qa.module_base import ModuleBase

from sandbox.sdk2.helpers import ProcessLog

import subprocess
import re


class DumperModule(ModuleBase):

    PARAMETER_TEMPLATES = {
        'start_time': 'start time(.*),',
        'end_time': 'end time(.*),',
        'full_time': 'full time(.*),',
        'data_readed': 'data readed(.*)',
        'requests': 'requests(.*)',
        'error_requests': 'error requests(.*)',
        'rps': 'requests/sec(.*)',
        'average_request_time': 'avg req. time(.*)',
        'avg req. len': 'avg req. len(.*)',
        'request_time_deviation': 'req time std deviation(.*)',
        'requests_moved': 'Moved temporarily(.*)',
        'requests_not_found': 'Not found(.*)',
        'bad_gateway': 'Bad gateway(.*)',
        'requests_ok': 'Ok(.*)',
        'service_unavailable': "Service unavailable(.*)",
    }

    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        self._d_dumper_path = self.adapter.get_d_dumper_path()
        self._compiled_temlpates = {key: re.compile(value) for key, value in self.PARAMETER_TEMPLATES.iteritems()}

    def _run_dumper(self, args):
        cmdline = [self._d_dumper_path] + list(args)
        with ProcessLog(self.adapter.task_instance, inspect.stack()[1][3]) as process_log:
            process_log.logger.propagate = True
            dumper_process = subprocess.Popen(map(str, cmdline), stdout=subprocess.PIPE, stderr=process_log.stderr)
            stdout, _ = dumper_process.communicate()
        return stdout

    def get_timeline(self, dump_path):
        args = ['-T', '-f', dump_path]
        raw_timeline = self._run_dumper(args)
        return [map(int, line.split()) for line in raw_timeline.strip('\n').split('\n')]

    def get_stats(self, dump_path):
        args = ['-a', '-f', dump_path]
        bounds_list = self.adapter.get_bounds_list()
        if bounds_list:
            args.extend([
                '-m', ','.join(str(bound) for bound in bounds_list)
            ])
        dumper_stats = self._run_dumper(args)
        return dumper_stats

    def get_processed_stats(self, dump_path, add_raw_stats=False):
        raw_stats = self.get_stats(dump_path)
        results = {}
        for result_name, pattern in self._compiled_temlpates.iteritems():
            match = pattern.search(raw_stats)
            if match:
                result_value = match.group(1).strip()
            else:
                result_value = None
            results[result_name] = result_value
        if add_raw_stats:
            results['raw_stats'] = raw_stats
        return results
