from sandbox.projects.yabs.qa.dumper_module import DumperModule
from sandbox.projects.yabs.qa.dumper_module.adapters.interface import DumperModuleAdapterInterface
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.common.dolbilka.resources import DDUMPER_EXECUTABLE
from sandbox.common.types.task import ReleaseStatus

from sandbox import sdk2
from parameters import DumperModuleParameters


class DumperModuleSandboxAdapter(DumperModuleAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return DumperModuleParameters

    def get_d_dumper_path(self):
        return self.sync_resource(sdk2.Resource.find(DDUMPER_EXECUTABLE, attrs={'released': ReleaseStatus.STABLE}).order(-sdk2.Resource.id).first())

    def get_bounds_list(self):
        return self.parameters.bounds_list

    def create_module(self):
        return DumperModule(self)
