from sandbox.projects.yabs.qa.dumper_module import DumperModule
from sandbox.projects.yabs.qa.dumper_module.adapters.interface import DumperModuleAdapterInterface
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.common.rest import Client

import json


class DumperModuleStandaloneAdapter(DumperModuleAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)

    def get_d_dumper_path(self):
        resource_data = Client().resource.read(limit=100,
                                               order='-id',
                                               type='DDUMPER_EXECUTABLE',
                                               attrs=json.dumps({'released': 'stable'}))['items'][0]
        return self.sync_resource(resource_data['id'])

    def get_bounds_list(self):
        return self.parameters.bounds_list

    def create_module(self):
        return DumperModule(self)
