import sys
from functools import wraps

from sandbox import sdk2
from sandbox.projects.yabs.qa.errorbooster.init import init_sentry
from sandbox.projects.yabs.qa.errorbooster.helpers import get_scope_tags
from sandbox.projects.yabs.qa.errorbooster.defaults import Auth, LogBroker, ErrorBooster


def track_errors(
        original_function=None,
        errorbooster_project=ErrorBooster.project,
        secret_id=Auth.secret_id,
        logbroker_token_key=Auth.logbroker_token_key,
        logbroker_topic=LogBroker.logbroker_topic,
        logbroker_source=LogBroker.logbroker_source,
):
    def inner(method):

        @wraps(method)
        def method_wrapper(task, *args, **kwargs):
            import sentry_sdk
            logbroker_token = sdk2.yav.Secret(secret_id).data()[logbroker_token_key]
            init_sentry(
                task,
                logbroker_token=logbroker_token,
                logbroker_topic=logbroker_topic,
                logbroker_source=logbroker_source,
                errorbooster_project=errorbooster_project,
            )
            with sentry_sdk.configure_scope() as scope:
                for name, value in get_scope_tags(task).items():
                    scope.set_tag(name, value)
                try:
                    return method(task, *args, **kwargs)
                except (sdk2.WaitTask, sdk2.WaitTime):
                    raise
                except:
                    exc_type, exc_value, exc_traceback = sys.exc_info()
                    sentry_sdk.capture_exception(error=(exc_type, exc_value, exc_traceback))
                    raise

        return method_wrapper

    if original_function:
        return inner(original_function)

    return inner
