import logging

from sandbox import sdk2

logger = logging.getLogger(__name__)


def get_test_cluster_from_tags(tags):
    if 'TESTENV-PRECOMMIT-CHECK' in tags:
        return 'precommit'
    if 'TESTENV-COMMIT-CHECK' in tags:
        return 'trunk'
    if 'TESTENV-RESOURCE-CHECK' in tags:
        return 'resource'
    if 'ONESHOT-TEST' in tags:
        return 'oneshot'
    if 'AB-EXPERIMENT-TEST' in tags:
        return 'ab_experiment'
    return 'unknown'


def get_scope_tags(task):
    tags = {}
    if isinstance(task, sdk2.Task):
        tags.update(
            reqid=str(task.id),
            block=str(task.type),
            service=get_test_cluster_from_tags(task.Parameters.tags),
        )
    else:
        logger.debug('Got %s as a task object, can not initialize scope tags from it', type(task))
    return tags


def get_user(task):
    if isinstance(task, sdk2.Task):
        return task.author
    else:
        logger.debug('Got %s as a task object, can not initialize user from it', type(task))
