import logging
import os

from sandbox import sdk2
from sandbox.projects.yabs.qa.errorbooster.defaults import LogBroker, ErrorBooster


logger = logging.getLogger(__name__)
__SENTRY_INITIALIZED = False


def init_sentry(
        task_obj=None,
        logbroker_token=None,
        errorbooster_project=ErrorBooster.project,
        logbroker_topic=LogBroker.logbroker_topic,
        logbroker_source=LogBroker.logbroker_source,
):
    global __SENTRY_INITIALIZED
    if __SENTRY_INITIALIZED:
        return

    import sentry_sdk

    from errorboosterclient.sentry import ErrorBoosterTransport, EventConverter
    from errorboosterclient.logbroker import LogbrokerClient

    class SandboxEventConverter(EventConverter):

        @classmethod
        def convert(cls, *args, **kwargs):
            result = super(SandboxEventConverter, cls).convert(*args, **kwargs)
            result['stack'] = result['stack'].replace(os.getcwd(), '')
            return result

    class SandboxErrorBoosterTransport(ErrorBoosterTransport):
        converter_cls = SandboxEventConverter

    lb_producer = LogbrokerClient(token=logbroker_token).get_producer(source=logbroker_source, topic=logbroker_topic)
    task_revision = 0
    if isinstance(task_obj, sdk2.Task):
        try:
            task_revision = task_obj.Requirements.tasks_resource.commit_revision
        except Exception as exc:
            logger.debug('Failed to get task\'s commit_revision. Got exception %s', exc, exc_info=True)
    else:
        logger.debug('Failed to get task\'s commit_revision. Got %s as a task object, sdk2.Task expected', type(task_obj))

    sentry_sdk.init(
        transport=SandboxErrorBoosterTransport(
            project=errorbooster_project,
            sender=lb_producer.write,
        ),
        environment='sandbox',
        release=str(task_revision),
        with_locals=False,
        default_integrations=False,
    )
    __SENTRY_INITIALIZED = True
