import time


ENDPOINTS_TABLE_PROXY = "hahn"
ENDPOINTS_TABLE_PATH = "//home/yabs-cs-sandbox/hamster/Endpoints"


def add_service_record(
        yt_client,
        resource_id,
        service_name,
        service_id,
        cluster,
        endpoint_set,
        service_type,
):
    now = int(time.time())
    row = {
        "resource_id": resource_id,
        "service_name": service_name,
        "service_id": service_id,
        "cluster": cluster,
        "endpoint_set": endpoint_set,
        "service_type": service_type,
        "created": now,
        "accessed": now,
    }
    yt_client.insert_rows(ENDPOINTS_TABLE_PATH, [row], format='json')


def delete_service_record(yt_client, resource_id, service_name):
    row = {
        "resource_id": resource_id,
        "service_name": service_name,
    }
    yt_client.delete_rows(ENDPOINTS_TABLE_PATH, [row], format='json')
