from sandbox.projects.yabs.qa.hamster.deploy import remove_stage as remove_deploy_stage
from sandbox.projects.yabs.qa.hamster.nanny.remove import remove_nanny_service
from sandbox.projects.yabs.qa.hamster.spec import ExternalServiceType, UnknownExternalServiceType


def remove_hamster(service_id, service_type, cluster, nanny_token, yp_token, force=False):
    if service_type == ExternalServiceType.NANNY.value:
        remove_nanny_service(
            nanny_token,
            service_id,
            cluster.upper(),
            force,
        )

    elif service_type == ExternalServiceType.DEPLOY.value:
        remove_deploy_stage(service_id, yp_token, force)

    else:
        raise UnknownExternalServiceType(service_type)
