from sandbox.projects.yabs.qa.module_base import ModuleBase


class MultipleSUT(ModuleBase):
    suts = []

    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)

        for _, child_adapter in adapter.sut_name_to_adapter.iteritems():
            self.suts.append(child_adapter.create_module())

        self._port = self.adapter.get_port()

    def __enter__(self):
        for sut in self.suts:
            sut.__enter__()
        self._active = True
        return self

    def __exit__(self, *args):
        for sut in self.suts:
            sut.__exit__(*args)
        self._active = False

    def __del__(self):
        for sut in self.suts:
            sut.__del__()

    def get_port(self):
        return self._port
