from sandbox.projects.yabs.qa.multiple_sut_wrapper.sut.adapters.interface import MultipleSUTAdapterInterface
from sandbox.projects.yabs.qa.multiple_sut_wrapper.sut import MultipleSUT
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase


class MultipleSUTStandaloneAdapter(MultipleSUTAdapterInterface, StandaloneAdapterBase):
    sut_name_to_adapter_class = dict()

    sut_name_to_adapter = dict()

    sut_name_to_kwargs = dict()

    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', work_dir='work_dir', base_dir='base_dir'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)
        for name, adapter_class in self.sut_name_to_adapter_class.iteritems():
            kwargs = self.sut_name_to_kwargs.get(name, {})
            self.sut_name_to_adapter[name] = adapter_class(parameters, logs_dir, resource_cache_dir, work_dir, base_dir, **kwargs)

    def get_port(self):
        return self.parameters.port

    def create_module(self):
        return MultipleSUT(self)
