import argparse
import itertools
import six

from sandbox.common.rest import Client


class MutableParameters(argparse.Namespace):
    @classmethod
    def __from_dict__(cls, source_dict, *prototypes):
        prototype_dict = {item.name: item.default for item in itertools.chain.from_iterable(iter(prototype) for prototype in prototypes)}
        prototype_dict.update(source_dict)
        return cls(**prototype_dict)

    @classmethod
    def __from_parameters__(cls, parameters, *prototypes):
        return cls.__from_dict__({key: value for (key, value) in parameters if isinstance(key, six.string_types)}, *prototypes)

    @classmethod
    def __from_task_id__(cls, task_id, *prototypes):
        client = Client()
        custom_fields_data = client.task[task_id].custom.fields.read()
        source_dict = {item['name']: item['value'] for item in custom_fields_data if isinstance(item['name'], six.string_types)}
        source_dict['__task_id'] = int(task_id)
        return cls.__from_dict__(source_dict, *prototypes)

    def __iter__(self):
        for key in self.__dict__:
            yield key, self.__dict__[key]

    def get(self, key, default=None):
        try:
            return self.__dict__[key]
        except KeyError:
            return default
