from sandbox.projects.yabs.qa.perf_module import PerfModule
from sandbox.projects.yabs.qa.perf_module.adapters.interface import PerfModuleAdapterInterface
from parameters import PerfModuleParameters
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.resource_types import FLAME_GRAPH_BUNDLE
from sandbox.common.types.task import ReleaseStatus

from sandbox import sdk2


class PerfModuleSandboxAdapter(PerfModuleAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return PerfModuleParameters

    def get_flamegraph_bundle_path(self):
        return self.sync_resource(sdk2.Resource.find(FLAME_GRAPH_BUNDLE, attrs={'released': ReleaseStatus.STABLE}).order(-sdk2.Resource.id).first())

    def get_perf_sample_frequency(self):
        return self.parameters.perf_sample_frequency

    def create_module(self):
        return PerfModule(self)
