from sandbox.projects.yabs.qa.perf_module import PerfModule
from sandbox.projects.yabs.qa.perf_module.adapters.interface import PerfModuleAdapterInterface
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.common.rest import Client

import json


class PerfModuleStandaloneAdapter(PerfModuleAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)

    def get_flamegraph_bundle_path(self):
        resource_data = Client().resource.read(limit=100,
                                               order='-id',
                                               type='FLAME_GRAPH_BUNDLE',
                                               attrs=json.dumps({'released': 'stable'}))['items'][0]
        return self.sync_resource(resource_data['id'])

    def get_perf_sample_frequency(self):
        return self.parameters.perf_sample_frequency

    def create_module(self):
        return PerfModule(self)
