import re

SMAPS_MAPPING_FIRST_LINE_RE = re.compile('[0-9a-fA-F]+-[0-9a-fA-F]+')


def read_smaps(pid):
    with open('/proc/{}/smaps'.format(pid)) as smaps_file:
        return parse_smaps(smaps_file)


def parse_smaps(smaps_lines):
    smaps = []
    cur_smap = {}
    for line in smaps_lines:
        if SMAPS_MAPPING_FIRST_LINE_RE.match(line):
            if cur_smap:
                smaps.append(cur_smap)
                cur_smap = {}
            continue
        k, _, v = line.partition(':')
        v = v.strip()
        cur_smap[k.strip()] = v[:-3] if v.endswith(' kB') else v
    smaps.append(cur_smap)
    return smaps
