from collections import defaultdict

MICROSECONDS = 10 ** 6


def generate_graph_data(timeline, precision_sec=1):
    points_map = defaultdict(int)
    bucket_size = precision_sec * MICROSECONDS

    min_start = min(timeline, key=lambda x: x[1])[1]
    for _, start, finish in timeline:
        midpoint = (start + finish) / 2
        bucket = (midpoint - min_start) / bucket_size
        points_map[bucket * precision_sec] += 1 / float(precision_sec)

    rps_points = sorted(points_map.items(), key=lambda x: x[0])[:-1]

    integral_avg_points = [
        rps_points[0]
    ]
    integral_sum = rps_points[0][1]
    interval_count = 1

    for time, value in rps_points[1:]:
        integral_sum += value
        interval_count += 1
        integral_avg_points.append((time, integral_sum / interval_count))

    return {"rps": rps_points, "avg_rps": integral_avg_points}
